<?php

use Carbon_Fields\Block;
use Carbon_Fields\Field;

Block::make('SLOTS LIST')
    ->add_fields(array(

        Field::make('text', 'heading', __('H2 перед списом слотов если нужен')),
        Field::make('association', 'slots', __('Выбрать слоты для вывода'))
            ->set_types(array(
                array(
                    'type' => 'post',
                    'post_type' => 'slots',
                )
            ))

    ))
    ->set_render_callback(function ($fields, $attributes, $inner_blocks) {
        $heading = $fields['heading'];
        $slots = $fields['slots'];

        if ($slots):
            $slots_items = [];
            foreach ($slots as $slot) {
                $slots_items[] = $slot['id'];
            }
            if ($heading) echo '<h2>' . $heading . '</h2>'
            ?>
            <div class="popular-hot_info">
                <?php
                $args = ['post_type' => 'slots', 'post__in' => $slots_items];
                $query = new WP_Query($args);
                while ($query->have_posts()):$query->the_post();
                    get_template_part('loop/content-slot-item');
                endwhile;
                ?>
            </div>
        <?php
        endif;

    });