<?php
$ref_all = carbon_get_theme_option('ref_all');
$ref_android2 = carbon_get_theme_option('ref_android2');
$ref_ios2 = carbon_get_theme_option('ref_ios2');
?>


<footer>
    <div class="footer-top">
        <a class="footer-logo__img" href="<?php echo home_url() ?>">
            <img alt="Mostbet Logo" src="<?php echo get_template_directory_uri() ?>/assets/img/mostbet-footer.png">
        </a>
        <div class="footer-menu">
            <?php
            $result = wp_nav_menu(array(
                'theme_location' => 'footer',
                'echo' => false,
            ));
            if ($result):
                $string = strip_tags($result, '<a>');
                echo $string;
            endif;
            ?>
        </div>
        <span class="age_limit">18+</span>
    </div>
    <div class="footer-middle">
        <div class="download-block">
            <span>Скачать:</span>
            <a class="download-icon" href="<?php echo $ref_android2; ?>" target="_blank" rel="nofollow">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" preserveAspectRatio="">
                    <path d="M4 15c0 1.1.9 2 2 2v2c0 .6.4 1 1 1s1-.4 1-1v-2h4v2c0 .6.4 1 1 1s1-.4 1-1v-2c1.1 0 2 .1 2-1V9H4v6zM2 8c-.6 0-1 .5-1 1v5c0 .6.4 1 1 1s1-.4 1-1V9c0-.5-.4-1-1-1zm12.7-6.2c.4-.4.4-1.1 0-1.5-.4-.4-1.1-.4-1.5 0l-1.1 1.1c-.7-.2-1.4-.4-2.1-.4-.7 0-1.4.2-2.1.4L6.8.3c-.4-.4-1.1-.4-1.5 0-.4.4-.4 1.1 0 1.5l.8.8C4.8 3.8 4 5.5 4 7.4V8h12v-.6c0-2-.8-3.7-2.1-4.9l.8-.7zM7.5 7C6.7 7 6 6.3 6 5.5S6.7 4 7.5 4 9 4.7 9 5.5 8.3 7 7.5 7zM14 5.5c0 .8-.7 1.5-1.5 1.5S11 6.3 11 5.5 11.7 4 12.5 4s1.5.7 1.5 1.5zM18 8c-.6 0-1 .4-1 1v5c0 .6.4 1 1 1s1-.4 1-1V9c0-.5-.4-1-1-1z"></path>
                </svg>
            </a>
            <a class="download-icon" href="<?php echo $ref_ios2; ?>" target="_blank" rel="nofollow">
                <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" preserveAspectRatio="">
                    <path d="M17.4 14.9c-.2-.1-2.3-1-2.3-3.5 0-2 1.5-3.1 1.9-3.3v-.2C15.9 6.3 14.2 6 13.6 6h-.3c-.8 0-1.5.3-2.1.5-.4.2-.8.3-1 .3-.3 0-.6-.1-1.1-.3-.6-.2-1.2-.5-1.9-.5-1.6 0-3 .9-3.9 2.3-1.5 2.7-.6 6.8 1.1 9.3.9 1.3 1.8 2.4 2.9 2.4h.1c.6 0 1-.2 1.3-.4.4-.2.9-.4 1.6-.4.7 0 1.1.2 1.5.4.4.2.8.4 1.5.3 1.3 0 2.2-1.2 2.9-2.3.8-1.1 1.1-2.2 1.3-2.6 0 0 0-.1-.1-.1zM9.7 5h.2c1 .1 2-.5 2.7-1.4.7-1 1-2.3.9-3.4 0-.1-.1-.2-.2-.2-1 0-2.2.6-2.8 1.5-.6.7-1.1 2-.9 3.3-.1.1 0 .2.1.2z"></path>
                </svg>
            </a>
        </div>
        <div class="footer-middle__icon">
            <ul>
                <li>
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 200 155.58">
                        <path d="M195.93 153.396v.405h.373c.082 0 .153-.02.204-.051.047-.032.075-.087.075-.153s-.028-.118-.075-.15a.358.358 0 00-.204-.05zm.376-.283c.193 0 .342.044.448.13s.158.204.158.354c0 .125-.04.228-.126.31a.613.613 0 01-.358.15l.495.57h-.385l-.46-.567h-.149v.566h-.322v-1.513zm-.098 2.036c.177 0 .342-.036.491-.102a1.252 1.252 0 00.77-1.171c0-.177-.035-.342-.098-.495-.066-.154-.157-.291-.27-.405s-.248-.205-.402-.271c-.149-.063-.314-.095-.49-.095s-.347.032-.5.095c-.157.066-.295.157-.408.27s-.205.252-.268.406c-.067.153-.098.318-.098.495s.031.342.098.495c.063.157.154.29.268.405s.251.204.408.27c.153.067.322.103.5.103m0-2.904c.231 0 .443.043.648.13a1.645 1.645 0 01.88.868c.086.196.13.409.13.633s-.044.436-.13.632-.204.37-.354.519a1.785 1.785 0 01-.526.35c-.205.086-.417.13-.649.13a1.704 1.704 0 01-1.187-.48c-.149-.15-.267-.322-.353-.519s-.13-.408-.13-.632.043-.437.13-.633a1.6 1.6 0 01.354-.519c.149-.15.326-.267.53-.35.204-.086.42-.13.656-.13m-153.102-5.827c0-2.884 1.89-5.254 4.979-5.254 2.951 0 4.943 2.268 4.943 5.254s-1.992 5.254-4.943 5.254c-3.089 0-4.979-2.37-4.979-5.254m13.286 0v-8.205h-3.568v1.992c-1.132-1.477-2.849-2.404-5.183-2.404-4.602 0-8.21 3.607-8.21 8.617 0 5.014 3.608 8.618 8.21 8.618 2.334 0 4.051-.927 5.183-2.405v1.992h3.568zm120.577 0c0-2.884 1.89-5.254 4.979-5.254 2.955 0 4.943 2.268 4.943 5.254s-1.988 5.254-4.943 5.254c-3.089 0-4.98-2.37-4.98-5.254m13.29 0v-14.795h-3.571v8.582c-1.132-1.477-2.85-2.404-5.183-2.404-4.602 0-8.21 3.607-8.21 8.617 0 5.014 3.608 8.618 8.21 8.618 2.334 0 4.051-.927 5.183-2.405v1.992h3.572zm-89.575-5.423c2.299 0 3.776 1.443 4.154 3.981H96.32c.381-2.37 1.82-3.98 4.362-3.98m.07-3.195c-4.81 0-8.173 3.5-8.173 8.617 0 5.219 3.501 8.618 8.413 8.618 2.472 0 4.736-.617 6.728-2.299l-1.749-2.645c-1.375 1.097-3.128 1.718-4.774 1.718-2.3 0-4.394-1.065-4.908-4.02h12.185c.036-.444.071-.892.071-1.372-.035-5.116-3.195-8.617-7.792-8.617m43.084 8.617c0-2.884 1.89-5.254 4.979-5.254 2.951 0 4.943 2.268 4.943 5.254s-1.992 5.254-4.943 5.254c-3.089 0-4.979-2.37-4.979-5.254m13.286 0v-8.205h-3.568v1.992c-1.136-1.477-2.849-2.404-5.183-2.404-4.602 0-8.21 3.607-8.21 8.617 0 5.014 3.608 8.618 8.21 8.618 2.334 0 4.047-.927 5.183-2.405v1.992h3.568zm-33.437 0c0 4.98 3.466 8.618 8.755 8.618 2.472 0 4.118-.55 5.903-1.957l-1.714-2.884c-1.34.962-2.747 1.477-4.295 1.477-2.849-.035-4.943-2.094-4.943-5.254s2.094-5.218 4.943-5.254c1.548 0 2.955.515 4.295 1.478l1.714-2.884c-1.785-1.407-3.431-1.957-5.903-1.957-5.289 0-8.755 3.638-8.755 8.617m46.004-8.617c-2.059 0-3.399.962-4.326 2.404v-1.992h-3.537v16.41h3.572v-9.199c0-2.715 1.167-4.224 3.501-4.224.723 0 1.478.102 2.232.412l1.1-3.363c-.79-.31-1.819-.448-2.542-.448m-95.65 1.717c-1.718-1.132-4.084-1.717-6.693-1.717-4.158 0-6.834 1.992-6.834 5.253 0 2.677 1.993 4.327 5.663 4.842l1.686.24c1.957.275 2.88.79 2.88 1.717 0 1.269-1.304 1.992-3.74 1.992-2.473 0-4.257-.79-5.46-1.717l-1.68 2.778c1.956 1.442 4.428 2.13 7.104 2.13 4.739 0 7.486-2.232 7.486-5.356 0-2.885-2.162-4.394-5.734-4.908l-1.681-.244c-1.545-.204-2.783-.51-2.783-1.611 0-1.203 1.167-1.922 3.124-1.922 2.095 0 4.123.79 5.117 1.407zm46.039-1.717c-2.06 0-3.4.962-4.323 2.404v-1.992h-3.537v16.41h3.568v-9.199c0-2.715 1.168-4.224 3.502-4.224.723 0 1.477.102 2.232.412l1.1-3.363c-.79-.31-1.82-.448-2.542-.448m-30.451.412h-5.836v-4.979h-3.607v4.98h-3.328v3.26h3.328v7.487c0 3.807 1.478 6.075 5.698 6.075 1.548 0 3.332-.48 4.464-1.27l-1.03-3.057c-1.064.617-2.232.928-3.159.928-1.784 0-2.366-1.1-2.366-2.747v-7.415h5.836zm-53.353 16.41v-10.3c0-3.878-2.471-6.487-6.456-6.522-2.094-.036-4.256.617-5.769 2.92-1.131-1.82-2.915-2.92-5.423-2.92-1.752 0-3.465.514-4.805 2.436v-2.024H10.25v16.41h3.603v-9.097c0-2.849 1.58-4.362 4.02-4.362 2.37 0 3.568 1.545 3.568 4.327v9.132h3.608v-9.097c0-2.849 1.646-4.362 4.016-4.362 2.436 0 3.603 1.545 3.603 4.327v9.132z"
                              fill="#fff"/>
                        <path d="M198.13 100.048V97.65h-.625l-.723 1.646-.72-1.646h-.628v2.397h.444V98.24l.676 1.56h.46l.676-1.564v1.812zm-3.965 0v-1.989h.801v-.404h-2.043v.404h.802v1.989z"
                              fill="#f79410"/>
                        <path d="M127.082 110.359H73.004V13.171h54.078z" fill="#ff5f00"/>
                        <path d="M76.469 61.757c0-19.715 9.23-37.276 23.605-48.593A61.538 61.538 0 0061.878-.052C27.745-.052.077 27.621.077 61.758s27.668 61.808 61.801 61.808a61.538 61.538 0 0038.196-13.215C85.699 99.034 76.469 81.472 76.469 61.757"
                              fill="#eb001b"/>
                        <path d="M200.016 61.757c0 34.137-27.668 61.81-61.801 61.81a61.557 61.557 0 01-38.2-13.216c14.378-11.317 23.61-28.879 23.61-48.594s-9.232-37.276-23.61-48.593a61.557 61.557 0 0138.2-13.216c34.133 0 61.801 27.673 61.801 61.81"
                              fill="#f79e1b"/>
                    </svg>
                </li>
                <li>
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 120 27">
                        <path fill="#FFF"
                              d="M59.532 1.627l-5.335 24.992h-6.459l5.336-24.992h6.458zM86.715 17.8l3.426-9.379 1.966 9.38h-5.392zm7.245 8.818h5.953L94.69 1.627h-5.504c-1.235 0-2.302.73-2.752 1.853l-9.716 23.139h6.796l1.348-3.707h8.312l.786 3.707zm-16.905-8.144c.056-6.57-9.098-6.964-9.042-9.884 0-.899.899-1.854 2.752-2.078.899-.113 3.482-.225 6.346 1.123l1.124-5.28c-1.573-.561-3.539-1.123-6.066-1.123-6.402 0-10.895 3.37-10.895 8.256-.057 3.595 3.2 5.617 5.672 6.796 2.527 1.236 3.37 2.022 3.37 3.089 0 1.685-2.022 2.415-3.875 2.471-3.258.056-5.111-.898-6.628-1.572l-1.18 5.503c1.517.674 4.325 1.292 7.19 1.348 6.795-.112 11.232-3.482 11.232-8.649M50.322 1.627L39.876 26.619h-6.852L27.857 6.68c-.337-1.235-.562-1.685-1.517-2.19-1.572-.843-4.1-1.629-6.346-2.134l.168-.73H31.17c1.404 0 2.64.954 2.977 2.527l2.696 14.434 6.74-17.018h6.739"/>
                    </svg>
                </li>
                <li>
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 60 27">
                        <circle fill="#EE0005" transform="translate(-32)" cx="55.4" cy="13.5" r="11"/>
                        <circle fill="#0098E2" transform="translate(-32)" cx="69.1" cy="13.5" r="11"/>
                        <path fill="#6C69BF"
                              d="M26.1 13.5c0 3.5 1.6 6.6 4.2 8.6 2.5-2 4.2-5.1 4.2-8.6s-1.6-6.6-4.2-8.6c-2.6 2-4.2 5.1-4.2 8.6z"/>
                    </svg>
                </li>
                <li>
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 120 27">
                        <path fill="#FFF"
                              d="M101.8.2c2 0 3.9.5 5.6 1.3.3.1.5.3.8.4l-1.2 1-1.8-1.8-3 2.7-1.8-1.9-5.6 5 3.6 3.9-1.3 1.2 3.5 3.9-1.4 1.2 5 5.5 3-2.7 2.6 2.9c-.5.4-1.1.8-1.7 1.1-1.9 1-4 1.6-6.3 1.6-7.1 0-12.8-5.7-12.8-12.7C89 5.9 94.8.2 101.8.2zm-2.3 11.9l3.1-2.7 2.7 3-3.1 2.7-2.7-3zm2.2 5.3l3-2.7 2.8 3-3.1 2.7-2.7-3zM97.3 7l3.1-2.7 2.7 3L100 10l-2.7-3zm5.6-1.5l2.3-2 2.1 2.3-2.3 2-2.1-2.3zm4.1 9.3l2.3-2 2.1 2.3-2.3 2-2.1-2.3zm2 4.6l2.3-2 2.1 2.3-2.3 2.1-2.1-2.4zm.9-10.5l1.5-1.4 1.4 1.5-1.5 1.4-1.4-1.5zM108 4.5l1.5-1.4 1.4 1.5-1.6 1.4-1.3-1.5zm3.9 8.9l1.5-1.4 1.4 1.5-1.5 1.4-1.4-1.5zm-6.9-3.3l2.3-2 2.1 2.3-2.3 2-2.1-2.3zM10.9 9.009h-.2l-2.1 8.2H6.8l-2.7-11.7H6l1.8 8.7h.1l2.2-8.7h1.4l2.3 8.7h.1l1.7-8.7h1.9l-2.6 11.7h-1.8zm9 3.191h3.8c-.1-1.7-.9-2.4-1.8-2.4-1.1 0-1.9.8-2 2.4m5 3.1v1.3c-.7.4-1.7.8-2.9.8-2.8 0-3.9-1.7-3.9-4.3 0-2.5 1.3-4.3 3.7-4.3 2.1 0 3.3 1.3 3.3 4v.6h-5.4c0 2 .8 2.9 2.5 2.9 1-.1 1.8-.4 2.7-1m4.1.7c.5.2 1.1.3 1.5.3 1.2 0 2.1-.8 2.1-3.4 0-2.1-.8-2.8-1.9-2.8-.7 0-1.1.2-1.8.5L29 16zm0-6.6c.5-.3 1.3-.6 2.2-.6 2 0 3.1 1.4 3.1 4.1 0 3.1-1.5 4.6-3.9 4.6-.9 0-2.2-.3-3.2-.8V5.1l1.8-.4v4.7zm12.8 5.3h.1l3.5-9.2h2v11.7h-1.8V8.7h-.1l-3.4 8.5h-1l-3.4-8.3h-.1v8.3h-1.5V5.5h2zM54.7 13c0-2.2-.9-3.2-2-3.2s-2 .9-2 3.2c0 2.3.9 3.2 2 3.2s2-.9 2-3.2m-5.8 0c0-2.9 1.6-4.3 3.7-4.3 2.2 0 3.7 1.4 3.7 4.3 0 2.8-1.5 4.3-3.7 4.3s-3.7-1.5-3.7-4.3m8.8-3.1c.7-.4 2.3-1.2 4.2-1.2 2 0 2.7.8 2.7 2.5v6h-1.7v-5.6c0-1.3-.6-1.5-1.5-1.5-.7 0-1.5.3-2 .6v6.5h-1.7V9.9zm10.5 2.3H72c-.1-1.7-.9-2.4-1.8-2.4-1 0-1.8.8-2 2.4m5.1 3.1v1.3c-.7.4-1.7.8-2.9.8-2.8 0-3.9-1.7-3.9-4.3 0-2.5 1.3-4.3 3.7-4.3 2.1 0 3.3 1.3 3.3 4v.6h-5.4c0 2 .8 2.9 2.5 2.9 1-.1 1.8-.4 2.7-1m7.1-6.6h1.8l-3 8.3c-.8 2.3-1.8 3.5-3.7 3.5v-1.4c1.1 0 1.8-.9 2.2-2.1l-3.2-8.3h1.8l2.1 6.1h.1l1.9-6.1z"/>
                        <path fill="#C0DAEC"
                              d="M21.9 24.8v-.7c.6.3 1.2.5 1.7.5s.8-.1 1.1-.3c.2-.2.4-.4.4-.7 0-.3-.1-.5-.3-.6-.2-.1-.6-.3-1.1-.5-.2-.1-.3-.1-.4-.1-.1 0-.2-.1-.3-.1-.2-.1-.3-.1-.3-.1s-.1-.1-.2-.1c-.1-.1-.2-.1-.2-.2s-.1-.1-.2-.2-.1-.2-.1-.2c0-.1 0-.2-.1-.3v-.3c0-.5.2-.8.5-1.1.3-.3.8-.4 1.4-.4.5 0 1.1.1 1.6.3v.8c-.5-.3-1-.4-1.6-.4-.4 0-.6.1-.8.2-.2.2-.3.4-.3.6 0 .3.1.5.3.6.2.1.5.3 1 .5.8.3 1.3.6 1.6.8.3.2.4.6.4 1.1 0 .5-.2.9-.6 1.2-.4.3-1 .5-1.7.5-.7-.4-1.3-.5-1.8-.8zm8.3.3h-.8l-.1-.5c-.5.4-.9.6-1.4.6-.4 0-.7-.1-.9-.3-.2-.2-.3-.5-.3-.8 0-.2 0-.3.1-.5s.2-.3.3-.5c.1-.1.4-.3.7-.4.3-.1.6-.1 1-.1h.5v-.2c0-.4-.1-.6-.2-.8-.1-.1-.4-.2-.7-.2-.4 0-.9.2-1.4.5v-.7c.6-.3 1.2-.4 1.7-.4s.9.1 1.1.3c.2.2.3.6.3 1l.1 3zm-.9-1.9h-.4c-.9 0-1.3.3-1.3.8 0 .2.1.3.2.4.1.1.3.1.4.1.2 0 .4-.1.7-.2.2-.1.4-.2.5-.4l-.1-.7zm2.2 3.6v-5.3c.2-.2.5-.3.8-.4.3-.1.6-.2 1-.2 1.1 0 1.7.7 1.7 2.1 0 .7-.1 1.3-.4 1.6-.3.4-.7.6-1.3.6-.4 0-.7-.1-1-.3v1.9h-.8zm.9-5.1v2.5c.1.1.2.2.4.2.2.1.3.1.4.1.3 0 .5-.1.7-.4.2-.2.3-.7.3-1.3 0-.5-.1-.9-.3-1.1-.2-.2-.4-.3-.7-.3-.3.1-.6.2-.8.3zm4.6-.8v4.2h-.8v-4l.8-.2zm-1-1.2c0-.1.1-.3.2-.4.1-.1.2-.2.4-.2.1 0 .3.1.4.2.1.1.2.2.2.4 0 .1-.1.3-.2.4-.1.1-.2.2-.4.2-.1 0-.3-.1-.4-.2-.1-.1-.2-.3-.2-.4zm4.2 4.9c.4 0 .8-.1 1.3-.4v.6c-.4.3-.9.4-1.4.4-.7 0-1.2-.2-1.5-.6-.3-.4-.5-.9-.5-1.6 0-.7.2-1.2.5-1.6.3-.4.8-.6 1.4-.6.5 0 .9.2 1.2.5.3.3.4.8.4 1.5v.3h-2.7c0 .5.1.9.3 1.1.2.3.5.4 1 .4zm-.3-3.2c-.3 0-.5.1-.6.3-.2.2-.3.5-.3.9h1.9c0-.4-.1-.7-.3-.9-.2-.2-.5-.3-.7-.3zm2.8 3.7v-3.6c.7-.4 1.4-.6 2.1-.6.5 0 .8.1 1 .3.2.2.3.5.3.9v3h-.8v-2.8c0-.3-.1-.5-.2-.6-.1-.1-.3-.2-.5-.2-.3 0-.7.1-1 .3v3.3h-.9zm5.5-4.1h1.3l-.2.6h-1.1v2.2c0 .6.2.8.7.8.2 0 .4 0 .5-.1v.5c-.3.1-.6.1-.9.1-.4 0-.7-.1-.9-.4-.2-.2-.3-.5-.3-.9v-3.4l.8-.6.1 1.2zm3-.1v4.2h-.8v-4l.8-.2zm-1-1.2c0-.1.1-.3.2-.4.1-.1.2-.2.4-.2.1 0 .3.1.4.2.1.1.2.2.2.4 0 .1-.1.3-.2.4-.1.1-.2.2-.4.2-.1 0-.3-.1-.4-.2-.1-.1-.2-.3-.2-.4zm6.8 1.5v.7c-.4-.3-.8-.4-1.2-.4-.2 0-.4 0-.5.1-.1.1-.2.2-.2.4s.1.3.2.4c.1.1.4.2.7.3.2.1.3.1.4.1.1 0 .2.1.4.2.1.1.3.2.3.2.1.1.1.2.2.3.1.1.1.3.1.4 0 .4-.2.7-.5.9-.3.2-.7.3-1.2.3-.6 0-1-.1-1.4-.4v-.6c.5.3.9.4 1.3.4.6 0 .9-.2.9-.6 0-.1 0-.1-.1-.2 0-.1-.1-.1-.1-.2 0 0-.1-.1-.2-.1-.1-.1-.2-.1-.3-.1-.1 0-.2-.1-.3-.1-.2-.1-.4-.2-.5-.2-.1-.1-.3-.1-.4-.2l-.3-.3c-.1-.1-.1-.3-.1-.5s.1-.4.2-.6c.1-.2.3-.3.4-.4.2-.1.3-.1.5-.1h.4c.4-.1.8.1 1.3.3zm4.5 3.9h-.8l-.1-.5c-.5.4-.9.6-1.4.6-.4 0-.7-.1-.9-.3-.2-.2-.3-.5-.3-.8 0-.2 0-.3.1-.5s.2-.3.3-.5c.1-.1.4-.3.7-.4.3-.1.6-.1 1-.1h.5v-.2c0-.4-.1-.6-.2-.8-.1-.1-.4-.2-.7-.2-.4 0-.9.2-1.4.5v-.7c.6-.3 1.2-.4 1.7-.4.6 0 .9.1 1.1.3.2.2.3.6.3 1l.1 3zm-.9-1.9h-.4c-.9 0-1.3.3-1.3.8 0 .2.1.3.2.4.1.1.3.1.4.1.2 0 .4-.1.7-.2.2-.1.4-.2.5-.4l-.1-.7zm3-2.2h1.3l-.2.6h-1.1v2.2c0 .6.2.8.7.8.2 0 .4 0 .5-.1v.5c-.3.1-.6.1-.9.1-.4 0-.7-.1-.9-.4-.2-.2-.3-.5-.3-.9v-3.4l.8-.6.1 1.2z"/>
                    </svg>
                </li>
                <li>
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 120 27">
                        <path fill="#8CC23C"
                              d="M27.5 2.2C17.8 2.2 10 6.8 10 12.5c0 2.4 1.4 4.6 3.8 6.4-1.2-1.5-1.9-3.1-1.9-4.8 0-5.9 7.7-10.7 17.2-10.7 6.1 0 11.5 2 14.5 5-2.8-3.7-8.9-6.2-16.1-6.2z"/>
                        <path fill="#FFF"
                              d="M25.9 15.4c.7 0 1.3-.2 1.7-.5.5-.3.8-.8.8-1.4 0-1.2-.4-2.3-1.1-3.3-.8-1-1.7-1.7-3-2.3-.8-.3-1.8-.5-2.8-.5-2.1 0-3.8.7-5.1 2-1.3 1.3-2 3-2 4.9 0 1.9.7 3.5 2.1 4.8 1.4 1.3 3.1 2 5.2 2 1.1 0 2.2-.2 3.2-.5 1.2-.4 2.1-.9 2.7-1.6.3-.4.5-.8.5-1.1 0-1-.6-1.5-1.7-1.5-.2 0-.9.2-1.9.6-1 .4-1.9.6-2.6.6-.9 0-1.6-.2-2.2-.6-.6-.4-.9-1-1-1.7h7.2zm-6.2-4.2c.5-.4 1.1-.6 1.9-.6.7 0 1.4.2 1.9.6.5.4.8 1 .8 1.6h-5.6c.1-.6.5-1.2 1-1.6zm11.1 7.9c1.3 1.3 3 2 5.1 2 1.3 0 2.3-.2 3.2-.6 1.2-.5 1.8-1.2 1.8-2 0-.5-.2-.9-.5-1.2-.3-.3-.7-.5-1.2-.5-.3 0-.7.1-1.3.3-.5.2-1.1.3-1.6.3-1 0-1.8-.3-2.3-.9-.5-.6-.7-1.3-.7-2.3 0-.9.2-1.7.7-2.3.5-.7 1.3-1 2.2-1 .6 0 1.2.1 1.7.3.5.2 1 .3 1.3.3.5 0 .9-.2 1.3-.5.3-.3.5-.7.5-1.2 0-.9-.6-1.6-1.7-2-.9-.3-1.9-.5-3-.5-2.2 0-4 .6-5.3 1.9-1.3 1.3-2 2.9-2 4.9-.1 2.2.5 3.8 1.8 5z"/>
                        <path fill="#FFF"
                              d="M42.9 19.2c1.4 1.3 3.1 2 5.2 2s3.9-.7 5.2-2c1.3-1.3 1.9-2.9 1.9-4.9 0-2-.7-3.6-2-4.9-1.3-1.3-3-2-5.2-2-2.1 0-3.8.7-5.2 2-1.3 1.3-2 3-2 4.9.2 1.9.8 3.6 2.1 4.9zm3.1-7.1c.5-.7 1.2-1 2.1-1 .9 0 1.6.3 2.1 1 .5.6.7 1.3.7 2.2 0 .9-.2 1.6-.7 2.2-.5.7-1.2 1-2.1 1-.9 0-1.6-.3-2.1-1-.5-.6-.7-1.3-.7-2.2 0-.9.2-1.6.7-2.2z"/>
                        <path fill="#8CC23C"
                              d="M61.2 7.1h1.9c2 0 3 .8 3 2.3 0 1.5-1 2.3-3 2.3h-1.9V7.1zm0 11.1v-3h2.9c2.1 0 3.7-.5 4.9-1.5 1.2-1 1.8-2.5 1.8-4.3 0-1.9-.7-3.3-2-4.4-1.2-1-2.9-1.5-5-1.5h-3.9c-1.1 0-1.9.2-2.3.6-.4.4-.7 1.1-.7 2.2v11.9c0 1.9.7 2.8 2.2 2.8 1.4 0 2.1-.9 2.1-2.8zm14.8-6c.5-.6 1.2-1 2.1-1 .9 0 1.6.3 2.1 1 .4.6.6 1.3.6 2.1s-.2 1.6-.6 2.1c-.5.7-1.2 1-2.1 1-.9 0-1.6-.3-2.1-1-.4-.6-.6-1.3-.6-2.1-.1-.9.2-1.6.6-2.1zm6.9 8.8c1.4 0 2.1-.9 2.1-2.8v-7.7c0-1.9-.7-2.8-2.1-2.8-.9 0-1.5.4-2 1.2-.9-.9-2-1.4-3.4-1.4-1.9 0-3.5.7-4.8 2.1-1.1 1.4-1.7 2.9-1.7 4.7 0 1.8.6 3.3 1.7 4.6 1.2 1.4 2.8 2.1 4.7 2.1 1.5 0 2.7-.5 3.6-1.4.3.9 1 1.4 1.9 1.4zM94.8 9.2l-2.6 6.1-2.4-5.8c-.3-.6-.5-1.1-.7-1.3-.3-.4-.8-.5-1.4-.5-.6 0-1.1.2-1.5.5s-.6.8-.6 1.4c0 .4.1.7.2 1.1l4.3 9-1.7 3.4c-.3.5-.4.9-.4 1.3 0 .6.2 1 .6 1.3.4.3.9.5 1.5.5.7 0 1.4-.5 1.9-1.5l6.4-13.9c.2-.5.3-.9.3-1.3 0-1.2-.7-1.8-2.1-1.8-.7 0-1.4.5-1.8 1.5zm14.3 8H105l5.6-6.5c.6-.7.9-1.2.9-1.7s-.2-.8-.7-1c-.4-.1-1.1-.2-2-.2H102c-1.8 0-2.7.6-2.7 1.7 0 1.2.9 1.8 2.7 1.8h3.6l-5.8 6.8c-.4.5-.6 1-.6 1.5 0 .8.7 1.2 2.2 1.2h7.7c1.8 0 2.7-.6 2.7-1.8 0-1.2-.9-1.8-2.7-1.8z"/>
                    </svg>
                </li>
                <li>
                    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 120 27">
                        <path fill="#F7931A"
                              d="M28.893 15.795c-1.5 5.9-7.4 9.4-13.3 8-5.9-1.5-9.4-7.4-8-13.3 1.5-5.9 7.4-9.4 13.3-8 5.9 1.5 9.4 7.5 8 13.3z"/>
                        <path fill="#FFF"
                              d="M23.093 11.595c.2-1.5-.9-2.2-2.4-2.8l.5-2-1.2-.3-.5 1.9c-.3-.1-.6-.2-1-.2l.5-1.9-1.2-.3-.5 2c-.3-.1-.5-.1-.8-.2l-1.7-.4-.3 1.3.9.2c.5.1.6.4.6.7l-.6 2.3-.8 3.2c-.1.1-.2.4-.6.3l-.9-.2-.6 1.4 1.6.4c.3.1.6.1.9.2l-.5 2 1.2.3.5-2c.3.1.6.2 1 .2l-.5 2 1.2.3.5-2c2.1.4 3.6.2 4.2-1.6.5-1.5 0-2.4-1.1-2.9.8-.3 1.4-.8 1.6-1.9zm-2.8 3.9c-.4 1.5-2.9.7-3.7.5l.7-2.6c.8.1 3.4.5 3 2.1zm.4-3.9c-.3 1.4-2.4.7-3.1.5l.6-2.4c.7.2 2.8.5 2.5 1.9zm18.7-2.7c.9 0 1.7.2 2.3.5.6.3 1.2.7 1.6 1.3.4.5.7 1.2.9 1.9.2.7.3 1.5.3 2.3 0 1.3-.2 2.5-.7 3.6-.5 1.1-1.1 2.1-1.9 3-.8.8-1.8 1.5-2.9 2-1.1.5-2.3.7-3.6.7h-.9c-.4 0-.9-.1-1.4-.1-.5-.1-1.1-.2-1.7-.3-.6-.1-1.2-.4-1.7-.6l4.8-20.2 4.3-.7-1.7 7.2c.4-.2.7-.3 1.1-.4.4-.2.8-.2 1.2-.2zm-3.6 11.8c.6 0 1.3-.2 1.8-.5.6-.3 1.1-.7 1.5-1.3.4-.5.7-1.1 1-1.8.2-.7.4-1.4.4-2.1 0-.9-.1-1.6-.4-2.1-.3-.5-.8-.7-1.6-.7-.3 0-.6 0-1 .1s-.8.3-1.1.6l-1.8 7.6c.1 0 .2 0 .3.1h.6c-.1.1.1.1.3.1zm13.2 3.1h-4.1l3.5-14.6h4.1l-3.5 14.6zm2-16.4c-.6 0-1.1-.2-1.6-.5s-.7-.9-.7-1.6c0-.4.1-.8.2-1.1l.6-.9.9-.6c.3-.1.7-.2 1.1-.2.6 0 1.1.2 1.6.5s.7.9.7 1.6c0 .4-.1.8-.2 1.1l-.6.9-.9.6c-.3.1-.7.2-1.1.2zm5.1-1.9l4.3-.7-1.1 4.3h4.6l-.8 3.4h-4.6l-1.2 5.1c-.1.4-.2.8-.2 1.2 0 .4 0 .7.1 1 .1.3.3.5.6.6.3.1.7.2 1.2.2.4 0 .9 0 1.3-.1s.8-.2 1.3-.3l.3 3.2c-.6.2-1.2.4-1.8.5-.6.1-1.4.2-2.3.2-1.3 0-2.3-.2-3-.6-.7-.4-1.2-.9-1.5-1.6-.3-.7-.4-1.4-.4-2.3 0-.9.2-1.7.4-2.7l2.8-11.4zm7.7 12.4c0-1.3.2-2.4.6-3.6.4-1.1 1-2.1 1.7-2.9.8-.8 1.7-1.5 2.8-2 1.1-.5 2.3-.7 3.6-.7.8 0 1.6.1 2.2.2.7.2 1.3.4 1.8.6l-1.4 3.2c-.4-.2-.8-.3-1.2-.4-.4-.1-.9-.2-1.5-.2-1.4 0-2.5.5-3.3 1.4-.8.9-1.2 2.2-1.2 3.8 0 .9.2 1.7.6 2.3.4.6 1.2.9 2.2.9.5 0 1.1-.1 1.6-.2s.9-.3 1.3-.4l.3 3.3c-.5.2-1.1.4-1.7.5-.6.2-1.4.2-2.2.2-1.1 0-2.1-.2-2.9-.5-.8-.3-1.5-.8-2-1.3-.5-.6-.9-1.2-1.1-2-.1-.5-.2-1.3-.2-2.2zm18.2 6.2c-1 0-1.8-.1-2.6-.4-.7-.3-1.3-.7-1.8-1.2s-.8-1.2-1.1-1.9c-.2-.7-.4-1.5-.4-2.4 0-1.1.2-2.2.5-3.3.4-1.1.9-2.1 1.6-3 .7-.9 1.6-1.6 2.6-2.2 1-.6 2.2-.8 3.5-.8 1 0 1.8.1 2.5.4.7.3 1.3.7 1.8 1.2s.8 1.2 1.1 1.9c.2.7.4 1.5.4 2.4 0 1.1-.2 2.2-.5 3.3-.3 1.1-.9 2.1-1.6 3-.7.9-1.5 1.6-2.6 2.2-.8.6-2 .8-3.4.8zm2.1-11.8c-.6 0-1.1.2-1.6.5-.5.4-.9.8-1.2 1.3-.3.5-.6 1.1-.7 1.8-.2.6-.2 1.2-.2 1.8 0 .9.1 1.6.4 2.2.3.5.8.8 1.6.8.6 0 1.1-.2 1.6-.5.5-.4.8-.8 1.2-1.3.3-.5.6-1.1.7-1.8.2-.6.2-1.2.2-1.8 0-.9-.1-1.6-.4-2.2-.3-.6-.8-.8-1.6-.8zm10.6 11.5h-4.1l3.5-14.6h4.1l-3.5 14.6zm2-16.4c-.6 0-1.1-.2-1.6-.5s-.7-.9-.7-1.6c0-.4.1-.8.2-1.1l.6-.9.9-.6c.3-.1.7-.2 1.1-.2.6 0 1.1.2 1.6.5s.7.9.7 1.6c0 .4-.1.8-.2 1.1l-.6.9-.9.6c-.3.1-.7.2-1.1.2zm4.5 2.4c.3-.1.7-.2 1-.3.4-.1.8-.2 1.3-.3.5-.1 1-.2 1.6-.3.6-.1 1.2-.1 2-.1 2.2 0 3.7.6 4.5 1.9.8 1.3 1 3 .4 5.2l-1.9 7.9h-4.1l1.8-7.7c.1-.5.2-.9.3-1.4.1-.5.1-.8 0-1.2-.1-.3-.2-.6-.5-.8-.3-.2-.7-.3-1.2-.3s-1.1.1-1.6.2l-2.7 11.3h-4.1l3.2-14.1z"/>
                    </svg>
                </li>
            </ul>
        </div>
    </div>
    <div class="footer__flex">
        <div class="footer__icon">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 80 26" width="79px">
                <path fill="#628EBA"
                      d="M.5 26h8.2v-9.4h5.7l2.2-5.7H8.7V5.7h9.6L20.4 0H.5v26zm22.4 0H31V0h-8.1v26zM70.2 0h-8.4l-9.3 26h7.8l1-3.5h9.1l1.1 3.5h8.1L70.2 0zm-7.5 17.5l3.1-10.8L69 17.5h-6.3zm-18-6.6V5.7h9.6L56.5 0H36.6v26h8.2v-9.4h5.7l2.2-5.7h-8z"></path>
            </svg>
        </div>
        <div class="footer__icon">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 40 45" width="40px">
                <path fill="#628EBA"
                      d="M10.2 27v7.2l1.9-1.5v-5.1l2.2 3.4 2-1.6v-8.9L14.4 22v5.7L12 23.9 9.2 26s1 0 1 1zm7.9-6v7.2l2-1.5v-3.3l2.2-1.7V25l1.9-1.4v-9l-1.9 1.5v3.3l-2.2 1.7v-3.3L17.2 20s.9 0 .9 1zm7.7-5.8v7.2l5.5-4.2c-.1-1.4 0-2.3 0-2.3l-3.5 2.7v-6.7l-2.9 2.2c-.1 0 .9.1.9 1.1zm10.9-8.5c-1.3-.4-2.3-1.4-2.9-3L32.5 0l-3 2.5c-1 .8-2.1 1.4-3.3 1.4-1.6 0-3.2-.8-4.2-1.8L20 .2v2c0 .1 2.4 3.2 6.1 3.2 2.8 0 5.7-2.9 5.7-2.9 1.3 5.7 6 6.1 6 6.1l1.9-.9-3-1zM12.1 38.4c3.4.9 5.7 1 7.2 1.7 0 0 .5.5.7.8.2-.3.7-.8.7-.8 1.5-.8 3.7-.9 7.2-1.7 4.3-1.1 9-5 9-11 0-4.3-2.4-5.9-2.4-11.4 0-3.7 1.4-6.6 1.4-6.6s-3.2-.7-4.7-4.7c0 0-2.1 2-5.1 2-3.7 0-6.1-2.6-6.1-2.6s-2.4 2.6-6.1 2.6c-2.9 0-5.1-2-5.1-2-1.5 4.1-4.7 4.7-4.7 4.7s1.4 2.9 1.4 6.6c0 5.5-2.4 7.1-2.4 11.4-.1 6.1 4.6 9.9 9 11zm23.3-11c0 5.1-4 8.5-7.8 9.5-2.7.7-6 1.1-7.1 1.7-.3.1-.5.4-.5.4l-.5-.5c-1-.6-4.3-1-7.1-1.7-.1-.1-.2-.1-.3-.1l21.4-16.2c.8 2.7 1.9 4.3 1.9 6.9zm-1.5-17.1c-.4 1.3-.9 3.4-.9 5.7 0 1 0 1.9.2 2.6L10.1 36c-2.9-1.5-5.4-4.4-5.5-8.3L31 7.7c1 1.3 2 2.1 2.9 2.6zM7.1 16c0-2.4-.5-4.4-.9-5.7 1-.6 2.3-1.6 3.3-3.3 1.1.6 2.6 1.3 4.4 1.3 2.7 0 4.9-1.2 6.1-2.1 1.2.9 3.4 2.1 6.1 2.1.4 0 .8-.1 1.2-.1l-22.5 17c.7-2.6 2.3-4.7 2.3-9.2zm6.8-10.7c3.7 0 6.1-3.2 6.1-3.2v-2L18.1 2c-1 1-2.6 1.8-4.2 1.8-1.2 0-2.3-.6-3.3-1.4L7.6 0l.6 2.4s2.8 2.9 5.7 2.9zM37.3 16c0-2.1.5-3.9 1.1-5.4l1.3-3-1.9.9s-1.9 3.4-1.9 7.5c0 2.2.8 3.9 1.6 5.8-.8-1.9-1.6-3.7-1.6-5.8 0 5.2 2.4 6.7 2.4 11.4 0 4.8-3 9.8-8.5 11.9-.5.2-1 .4-1.6.5-3.1.8-5.2 1-6.8 1.6-.2.2-1.5 1.6-1.5 1.6s-1.3-1.5-1.5-1.6c-1.5-.6-3.7-.8-6.8-1.6-.2 0-.3-.1-.5-.1-.2-.1-.4-.1-.6-.2h-.1c-5.7-2-8.8-7.1-8.8-12 0-4.3 2-5.9 2.4-9.9v-1.5C4 12 2.1 8.6 2.1 8.6s4.7-.4 6-6.2L7.6 0 6.2 3.7c-.6 1.6-1.5 2.6-2.9 3l-3 .9 1.3 3c.6 1.5 1.1 3.4 1.1 5.4 0 5.1-2.5 6.1-2.5 11.4 0 1.6.2 3.2.7 4.5.1-.3.4-.7.6-.9-.2.2-.5.5-.6.8 1.6 4.7 5.8 8 10.3 9.2 2.9.8 4.2.8 6.4 1.4.5.4 2.4 2.6 2.4 2.6s2-2.2 2.2-2.5c2.1-.6 3.5-.7 6.4-1.4 5.8-1.5 11.1-6.6 11.1-13.7 0-2.6-.5-4.1-1.1-5.6-.6-1.6-1.3-3.2-1.3-5.8zm-31 21.4c1.3.9 2.6 1.5 4 2-1.3-.5-2.7-1.2-4-2z"></path>
            </svg>
        </div>
        <div class="footer__icon">
            <svg baseProfile="basic" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 59 46" width="56px">
                <path fill="#628EBA"
                      d="M21.9 3.3C12.8 6.8 5.5 13.2 2.2 20.4c-2 4.6-2.3 9.2-.7 13.3 2.8 7.2 10.9 11.7 21.3 11.7 4.7 0 9.6-.9 14.3-2.7 9.1-3.5 16.5-9.9 19.7-17.1 2-4.6 2.3-9.2.7-13.3C54.7 5.1 46.5.6 36.2.6c-4.7 0-9.6.9-14.3 2.7"></path>
                <path fill="#FFF"
                      d="M47.7 27.9c0 1.1-.9 2-1.9 2-1.1 0-1.9-.9-1.9-2s.9-2 1.9-2c1 0 1.9.9 1.9 2"></path>
                <path fill="#E3F2FF"
                      d="M40.9 17.9c0-1-.7-1.6-1.7-1.7H25.5c-.7 0-1.2.4-1.5.9-.1.2-.2.3-.2.3L21 23.8s-2.6-5.8-2.7-6l-.2-.4c-.4-.9-1-1.3-1.7-1.3-.6 0-1.2.3-1.7 1.2 0 0-.1.1-.2.4S12 23.8 12 23.8l-2.7-6.1-.1-.2c-.4-.8-.8-1.3-1.7-1.3-.6 0-1.2.3-1.5.9-.2.3-.4.8 0 1.7 0 .1 0 .1.1.3.6 1.4 3.4 7.7 4.1 9.3.1.2.2.3.2.5.4.7.9 1.1 1.5 1.1s1.2-.3 1.6-1.1l.3-.6 2.7-6.1s2.7 6.2 2.8 6.3c.1.1.1.2.2.4.3.6.8 1 1.5 1s1.1-.4 1.5-1c.1-.1.1-.3.3-.5.1-.2 3.9-8.8 3.9-8.8h4.4V28c0 1 .8 1.8 1.7 1.8 1 0 1.7-.8 1.7-1.8v-8.4h4.7c.9 0 1.7-.8 1.7-1.7m11.9 8.9l-.1-.2-5.3-9.3-.2-.3c-.4-.6-.8-.9-1.5-1-.7 0-1.1.4-1.5 1l-.2.3-5.2 9.2-.2.3c-.2.4-.4.7-.4 1.2 0 1 .7 1.7 1.7 1.7.6 0 1.1-.4 1.5-1l.2-.2 4.1-7.3 4.1 7.3.1.2c.4.6.9 1 1.6 1 .9 0 1.7-.7 1.7-1.7 0-.4-.2-.8-.4-1.2"></path>
            </svg>
        </div>
        <div class="footer__icon">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 63 33" width="61px">
                <path fill="#628EBA"
                      d="M.5 3.6v27.3h5.8V18.8h8.2v-5.5H6.3V7.2h9.8V1.6H2.5c-1.4 0-2 .6-2 2zm17.7.1V31H24V1.7h-3.8c-1.4 0-2 .6-2 2zm22.3 12.5c1.4-.6 3.4-2.2 3.4-6.9 0-4-2.8-7.7-8.6-7.7h-6.4c-1.4 0-2 .6-2 2V31h8.8c4.8 0 8.4-2.8 8.4-8.3 0-4-2.2-5.9-3.6-6.5zm-5.6 9.7h-2.6v-7.3h2.6c2 0 3.4 1.2 3.4 3.6 0 2.5-1.4 3.7-3.4 3.7zm0-12.1h-2.6V6.7h2.6c2-.2 3.4 1 3.4 3.4 0 2.5-1.4 3.7-3.4 3.7zM55.1 1c-7.2 0-8.4 5.7-8.4 7.9v22h5.8V21h5.4v10h5.6V9c0-2.3-1.2-8-8.4-8zm2.4 14.6h-5.2V9.5c0-1.2.4-3.2 2.6-3.2s2.6 2 2.6 3.2v6.1z"></path>
            </svg>
        </div>
        <div class="footer__icon">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 49 56" width="48px">
                <path fill="#628EBA"
                      d="M49 52.6c0 1.8-1.5 3.4-3.4 3.4H3.4C1.5 56 0 54.5 0 52.6V3.4C0 1.5 1.5 0 3.4 0h42.2C47.5 0 49 1.5 49 3.4v49.2z"></path>
                <path fill="#E3F2FF"
                      d="M15.2 38.1c-1.8 0-2 .1-3 1.3l-7.5 9.1c3.5 0 3.4.1 4.4-1.2l.6-.7h6.4l.2.7c.2.8.2 1.1 1.6 1.2h1.8L17 38.1h-1.8zm-4.1 6.7l3.7-4.8 1 4.8h-4.7zm20.3-5.1c.3-.1.4-.3.5-.6.1-.2.2-.5.3-1.1h-9c-2 0-2.1.1-2.7 1.9h4l-2 6.9c-.4 1.6-.3 1.6 2.6 1.6l2.4-8.5h1.8c1.2.1 1.7 0 2.1-.2zm13 1.8c.4-1.5.4-3.4-5.2-3.4h-4.1c-1.5.1-1.6.8-1.8 1.6l-2 7.1c-.2.8-.3 1.2 0 1.4.5.3 2 .2 2.6.2l.5-1.7.5-1.8h2.5c5.6.1 6.5-1.9 7-3.4zm-3.2 0c-.5 1.7-.5 1.7-3.4 1.7h-2.4l.9-3.2h2.4c2.7 0 2.7.8 2.5 1.5zm-31.1 8.9l-1.2 1.8-.2-1.8c0-.1 0-.3-.2-.4-.2-.1-.7 0-.9 0L6 52.3l-.2-1.8c0-.1 0-.3-.2-.4-.2-.2-.6-.1-.8-.1l.5 3.1h.4c.7 0 .7 0 1-.5L8 50.8l.3 2.3h.5c.2 0 .4 0 .5-.1l.4-.4 1.9-2.7c-1.2.1-1.2 0-1.5.5zm3.6-.5c-1.7 0-2.3.8-2.6 1.6-.2.8-.1 1.6 1.7 1.6 1.7 0 2.3-.8 2.6-1.6.2-.8 0-1.6-1.7-1.6zm.7 1.6c-.3 1-.3 1-1.5 1-1 0-1.1-.4-.9-1 .3-1 .3-1 1.5-1 1 0 1.1.4.9 1zM18 50h-1.2c-.5 0-.5.2-.5.5l-.6 2.1c-.1.2-.1.4 0 .4.1.1.6.1.8.1l.4-1.3.4-1.3h.7c.8 0 .8.2.8.4 0 .1-.1.3-.2.4-.1.1-.4 0-.8 0h-.3c-.4 0-.5.3-.4.5l.8.9c.3.3.4.3.9.3h.6l-1.2-1.2c.7 0 1.4-.3 1.6-1-.1-.3-.1-.8-1.8-.8zm3.7 2.5h-.9l.6-2.1c.1-.2.1-.4 0-.4-.1-.1-.6-.1-.8-.1l-.8 2.6c-.1.5 0 .5.6.5h1.8c0-.1.2-.4 0-.5h-.5zm3.7-2.5h-.9c-.8 0-.8 0-1 .5l-.5 1.6-.1.5c0 .1-.1.3 0 .4.1.1.3.1.7.1h.8c1.4 0 2.3-.6 2.6-1.6.2-1-.3-1.5-1.6-1.5zm.6 1.5c-.3 1-.3 1-1.6 1h-.6l.6-2h.6c.9 0 1.3.2 1 1zm6-1.2c0-.1.1-.1.1-.3h-2.7c-.6 0-.6 0-.8.6h1.2l-.6 2.1c-.1.5-.1.5.8.5l.7-2.6h.5c.3 0 .5 0 .6-.1l.2-.2zm2.3-.4c-1.7 0-2.4.8-2.6 1.6-.2.8-.1 1.6 1.7 1.6 1.7 0 2.3-.8 2.6-1.6.2-.8.1-1.6-1.7-1.6zm.8 1.6c-.3 1-.3 1-1.5 1-1 0-1-.4-.9-1 .3-1 .3-1 1.5-1 1 0 1 .4.9 1zm5.5-1.5c-.1-.1-.6 0-.8 0l-.7 2.5h-1c-.8 0-.9-.3-.7-.8l.4-1.3c.1-.2.1-.3 0-.4-.1-.1-.6-.1-.8-.1l-.5 1.7c-.3 1 .1 1.4 1.5 1.4h1.4c.2 0 .4-.1.5-.2 0-.1.1-.2.1-.3l.6-2.1c.1-.2.1-.3 0-.4zm2.3 0h-1.2c-.5 0-.5.2-.5.5l-.6 2.1c-.1.2-.1.4 0 .4.1.1.6.1.8.1l.4-1.3.4-1.3h.7c.8 0 .8.2.8.4 0 .1-.1.3-.2.4-.1.1-.4 0-.8 0h-.3c-.4 0-.5.3-.4.5l.8.9c.3.3.4.3.9.3h.6L43 51.9c.7 0 1.4-.3 1.6-1 0-.4 0-.9-1.7-.9zm.9-1.5l.3-1.3h.5l.1-.3h-1.4l-.1.3h.5l-.3 1.3h.4zm2.4-1.6l-.6 1.2-.1-1.2H45l-.4 1.7h.3l.3-1.3.2 1.3h.3l.7-1.3-.4 1.2h.4l.3-1.7h-.5zM5.3 21.5l.4-.9.1.1s-.1.1-.1.2c.1.2.1.2.1.3.1.1.1.1.2.3v.6s.1.1.1.2c0 .2.1.3.2.6 0 .1.1.1.1.1.5 1 1.6 4.1 3.3 5.6 0 0 .6.1 1.2.5v.1l-.1.2s.4.2.7.4c.3.2 1.8 1 2.6 1.4l.4 2.3h.3c-3.7 1-7.1 2.4-10 4.3 5.6-2.6 12.5-4.1 19.9-4.1 7.4 0 14.2 1.5 19.9 4.1-4.2-2.8-9.5-4.7-15.3-5.3.4-.9 1.3-1.3 1.3-1.3.3-.2 2.9-.5 2.9-.5v-.2c3.2-.7 4.8-1.9 4.8-1.9.6-.1.7-.3.7-.3.1-.1.5-.4.5-.4 1.8-1.2 3.8-4.7 3.8-4.7.4.1.5-.3.5-.3.2-.2 1.1-1.4 1.1-1.4.3-.2.1-.4.1-.4l-.2-.1v-.1c.1-.1.3-.6.4-.7.1-.1.3-.7.3-.7.1-.2.3-.8.3-.8.2-.3.2-.6.2-.6-.1-.3-.5-.4-.5-.4 0-.3-.5-.4-.5-.4 0-.3-.5-.3-.5-.3-.1-.2-.5-.2-.5-.2-.2-.3-.5 0-.5 0-.1.2-.3.2-.3.2-.5 0-.6.3-.6.3l-.1.4c-.3.7-.1.9-.1.9l.2.4.2 1c-.3 0-.3.4-.3.4-.1.3-1 1.3-1 1.3-.3.1-.1.5-.1.5-.9.8-1.4 1-1.4 1-1.9 1.2-3.3 2.8-3.3 2.8-1.2-.2-2.7.1-2.7.1v-.2c-.8.2-1.7.7-1.7.7-.2.1-.6 0-.6 0-1.3-.7-3.6-.5-3.6-.5-1.2.3-1.4.4-1.4.4l-2.2.1-.1-.4c0-.1-.2-.2-.2-.2 0-.1 0-.3-.1-.4l-.1-1.3.6-.7c.2 0-.1-1.8-.1-1.8.1-.3-.4-1.3-.4-1.3.1-.8-.4-1.3-.4-1.3s-.3-.4-.4-.7c-.1-.3-.9-.7-1.4-.9-.6-.2-1.6 0-2.8.8-1.2.8-1.4 2.4-1.4 2.6 0 .2.4 1.4.4 1.5-.1 0-.3-.1-.1.6.2.7 1 1.2 1 1.2.2.1.5 1.2.7 1.7h-.4l-.1.2-.3.2c-.1 0-.4.1-.7.1-.3-.1-1.5-.4-3.2-.1l-1.7-.9-.1.2c-.5-.1-1-.2-1.6-.2 0 0-1.3-2.5-2.4-3.4V22c.1-.1 0-.3 0-.5 0-.1-.4-.5-.4-.5l-.5-.8s-.2-.4-.2-.6c-.1-.2-.3-.1-.3-.1-.1-.3-.1-.5 0-.6.1-.1.5-1.6.5-1.9 0-.2-.4-1.1-.5-1.3.5-.4 1.5-1.3 1.7-1.4 1.9-1.1 3.6-2.6 4.4-4.7 1.2-3.3.6-6.1-1.5-7.2h-.3C10 1.7 7.7 2.8 6.2 6c-.9 2-1 4.2-.5 6.5.1.5.1 1.2.1 2v.1l-.6.1c-.2.1-.2.3-.2.3l.2 1c-.1 0-.3.1-.3.4-.3.1-.3.5-.3.5-.4.1-.3.5-.3.5-.3.2-.1.5 0 .6.1.2.5 1.1.5 1.1l-.5 1.3c-.6 1.5-1.2 2.9-1.2 2.9l-.1.1h-.1l-.1.2c.2.3.5.4.8.6.3.2.5.2.6.2.1-.1.1-.2.1-.2V24s.4-1.2 1-2.5zm3.4-7c0 .1-.1.2-.3.3 0 0-.7.6-1 .9H7l-.2-.1c0-.4-.4-.7-.4-.7v-1.5c0-.1.1-.1.1-.1l.3.3c.2.1.3.3.7.4.4.2.5.2.7.2h.3c.1 0 .1 0 .2.1v.2zM7 6.5c.5-1.2 2.3-4.5 4.9-3.3 2.4 1.1 2.2 4.3 1.2 6.4-1.4 3-3.5 4.9-5.5 3.8-2-1.3-1.3-5-.6-6.9z"></path>
            </svg>
        </div>
        <div class="footer__icon">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 75 36" width="71px">
                <path fill="#628EBA"
                      d="M37.8 22.5c-9 0-17 4-22.5 10.2l1.2 1.2c5.2-5.9 12.8-9.7 21.1-9.7 8.7 0 16.4 4 21.6 10.2l1.4-1.2C55.1 26.7 47 22.5 37.8 22.5zm.4-21.1c-14.5 0-27.5 6-36.7 15.7L3 18.7C11.7 9.4 24.3 3.5 38.2 3.5c13.7 0 26 5.7 34.8 14.9l1.6-1.6C65.3 7.3 52.5 1.4 38.2 1.4zM20.7 22c0-1.5-.5-2.6-1.5-3.8l-4.6-5.7-2 1.7 4.1 5.1c1.3 1.6 2.1 3.1.4 4.8-2.1 1.7-3.6.8-4.6-.4L7.8 18l-2 1.6 4.8 6c.9 1.1 2.2 2 4.1 2 1.4 0 2.7-.6 3.5-1.3 1.5-1.1 2.5-2.6 2.5-4.3zM33 6.6l-7.4 1.5c-1.1.3-1.3.7-1 1.7l1.6 7.8c.4 1.7 1.3 3.3 4.8 2.6l4.6-.9-.5-2.4-4.5.9c-1.2.3-1.7 0-2-1.1l-.3-1.3 5.8-1.2-.5-2.3-5.7 1.2-.6-2.8 6.3-1.2-.6-2.5zm15.9 3.9l4.1 1.1.6-2.4L49.1 8c-1.6-.4-4.2-.7-5.1 2.3l-1.9 7.4c-.5 1.6 0 1.9 1 2.2l1.1.2 1.3-5.1 5.7 1.5.6-2.3-5.6-1.4.4-1.5c.3-1.3 1.2-1.1 2.3-.8zm16.4 5c-.5-.4-1.1-.4-1.9.2l-10.8 6.9L55 24l8-5.2-1.3 4.2-1-.8-2.2 1.4 2.4 1.9-.6 2.5 2.1 2 3.3-11.6c.5-1.9.4-2 0-2.4l-.4-.5z"></path>
            </svg>
        </div>
        <div class="footer__icon">
            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
                 viewBox="0 0 94 27" width="98px">
                <path fill="#D7E9F9"
                      d="M10.6 0H4.5C2.2 0 .4 1.8.4 4.1v18.8c0 2.3 1.8 4.1 4.1 4.1h6.1c2.3 0 4.1-1.8 4.1-4.1V4.1c0-2.3-1.9-4.1-4.1-4.1z"></path>
                <g transform="translate(-13)">
                    <defs>
                        <path id="a__ovrcGdMI"
                              d="M26.8 22.9V12.6c-4.2 1.1-12.7 3.8-12.7 6.9v3.4c0 1.8 1.5 3.3 3.3 3.3h6.1c1.8 0 3.3-1.5 3.3-3.3z"></path>
                    </defs>
                    <use xlink:href="#a__ovrcGdMI" overflow="visible" fill="#628eba"></use>
                    <clipPath id="b__ovrcGdMI">
                        <use xlink:href="#a__ovrcGdMI" overflow="visible"></use>
                    </clipPath>
                    <path clip-path="url(#b__ovrcGdMI)" fill="#628EBA"
                          d="M14.1 12.6h12.7v13.5H14.1z"></path>
                </g>
                <path d="M7.5 13.1c-.4 0-.7.1-.7.2v.4c0 .1.3.2.7.2.4 0 .7-.1.7-.2v-.4c0-.1-.3-.2-.7-.2z"></path>
                <g transform="translate(-13)">
                    <defs>
                        <path id="c__ovrcGdMI"
                              d="M19.6 6.7v.1s.2-.1.2-.2l.2-.3V6s-.3-.4-.4-.6c-.1-.2-.1-.5-.1-.7l-.2-.1-.2-.1v.3c.2.3.3.6.3.6l.3.4v.1s0 .1.1.3c0 .3-.2.6-.2.5zm-2 6.4l-.1.1h.3c.1-.1-.1-.1-.2-.1zm-.1-.2c-.1-.1-.1-.1 0 0-.1 0-.1 0 0 0zm3.1-3.4c-.1.1-.1.1-.1.2h-.1v.7l-.4.6c-.2.3-.4.3-.4.4v.5s0 .4-.2.6c0 0 0 .1-.1.1s-.5.1-.5.1 0 .1-.1.2c1.2-.3 2.5-.5 3.9-.7l-2-2.7zM18.4 11v-1c0-.2 0-.3.1-.4 0-.1.2-.2.2-.2v-.2l.1-.1s0-.1.1-.3c0-.1.4-1 .6-1.3l-.1-.3h-.2l-.2-.1V7s-.1 0-.1-.1l-.1-.2c-.1 0-.1-.3-.1-.3v-.7l-.1-.1c0-.1-.1-.4-.1-.4s-.5 0-.5-.2c0 0-.2-.5-.3-.8v-.7s.5-.8.7-.9c.1-.1.6-.3.8-.4h.9v-.7c0-.1 0 0 .1-.2 0-.1.1-.2.2-.3h-3.1C15.5 1 14 2.5 14 4.3v10.4c.9-.4 2-.7 3.2-1v-.1s.1-.2.1-.3h-.2v-.2s-.1 0-.1-.1v-.4c0-.1.2-.1.2-.1l.6-.1c.2-.1.5-.6.5-.6s.1-.7.1-.8zm5.1.8c0 .1-.2.3-.4.4 1.2-.1 2.4-.3 3.7-.4V4.1c0-1.8-1.5-3.3-3.3-3.3h-2l.1.1c.1.2.1.4.1.4v1s.1.2.2.2c0 0 .2.3.3.4.1.1.2.3.3.5.5.4.5.6.5.6 0 .2.3 1.4.4 1.8v.9c0 .1-.1.4-.1.4v.2s.2.5-.3.9c-.6.5-1.5.9-1.6 1l-.2-.4h-.4l1.5 2.8c.1.2.1.3.3.3.1 0 .3-.1.6-.2.2-.1.4-.4.5-.5h.1v.1c-.1.1-.2.4-.3.5z"></path>
                    </defs>
                    <use xlink:href="#c__ovrcGdMI" overflow="visible" fill="#628eba"></use>
                    <clipPath id="d__ovrcGdMI">
                        <use xlink:href="#c__ovrcGdMI" overflow="visible"></use>
                    </clipPath>
                    <path clip-path="url(#d__ovrcGdMI)" fill="#628EBA"
                          d="M14.1.8h12.7v13.6H14.1z"></path>
                </g>
                <path fill="#D7E9F9"
                      d="M11.8 24.4h1.7v-.1c-.6 0-1.2 0-1.7.1-.3-.1-.7-.1-1-.1 0-.2 0-.4.1-.7h-.1c0 .2 0 .5-.1.7-2.4-.2-4.7-.9-6.3-1.8.8-1.5 1.9-3.1 3.3-4.6l.2-.2c1 .5 2.4.9 4 1.1-.2.5-.4 1.1-.5 1.7h.1c.1-.6.3-1.2.5-1.7.6.1 1.2.1 1.8.1v-.1c-.6 0-1.2 0-1.8-.1.5-1.4 1.1-2.7 1.8-3.7v-.2c-.7 1-1.4 2.4-1.9 3.9-1.5-.2-2.9-.6-4-1.1 1.4-1.4 2.9-2.6 4.3-3.5.3.3 1.1.5 1.6.6v-.1c-.7-.1-1.2-.3-1.5-.5.5-.3 1-.5 1.5-.7v-.1c-.5.2-1.1.5-1.6.8-.1-.1-.1-.2-.1-.2 0-.3.5-.6 1.3-.8-.4-.1-.7-.1-1 0-.3.2-.5.4-.5.6 0 .1 0 .2.1.3-1.4.8-2.9 2.1-4.3 3.5-1-.5-1.6-1-1.6-1.5s.4-.9 1.2-1.3c-.3.1-.5.2-.8.3-.3.3-.5.6-.5.9 0 .5.6 1.1 1.6 1.6 0 .1-.1.1-.2.2C6 19.2 4.8 20.8 4 22.4c-1.8-1-3-2.1-3-2.9v.4c.3.7 1.4 1.7 3 2.5-.6 1.2-1 2.4-1.1 3.3H3c0-.9.4-2.1 1.1-3.3h.1c1.9 1 4.2 1.6 6.3 1.8 0 .6-.1 1.2-.1 1.8 0-.5 0-1.1.1-1.7.6.1.9.1 1.3.1z"></path>
                <path fill="#D7E9F9"
                      d="M3.6 23.3c0 .2-.2.4-.4.4H3c-.2 0-.4-.2-.4-.4v-2.6c0-.2.2-.4.4-.4h.2c.2 0 .4.2.4.4v2.6zm1.8 0c0 .2-.2.4-.4.4h-.2c-.2 0-.4-.2-.4-.4v-2.6c0-.2.2-.4.4-.4H5c.2 0 .4.2.4.4v2.6zm3.7 0c0 .2-.2.4-.4.4h-.2c-.2 0-.4-.2-.4-.4v-.9h-.9v.9c0 .2-.2.4-.4.4h-.2c-.2 0-.4-.2-.4-.4v-2.6c0-.2.2-.4.4-.4h.2c.2 0 .4.2.4.4v.9h.9v-.9c0-.2.2-.4.4-.4h.2c.2 0 .4.2.4.4v2.6zm2.9-1.7c.2 0 .4.2.4.4s-.2.4-.4.4h-1v.9c0 .2-.2.4-.4.4h-.2c-.2 0-.4-.2-.4-.4v-2.6c0-.2.2-.4.4-.4H12c.2 0 .4.2.4.4s-.2.4-.4.4h-1v.5h1z"></path>
                <path fill="#628EBA"
                      d="M10.6 0H4.5C2.2 0 .4 1.8.4 4.1v18.8c0 2.3 1.8 4.1 4.1 4.1h6.1c2.3 0 4.1-1.8 4.1-4.1V4.1c0-2.3-1.9-4.1-4.1-4.1zm3.6 22.9c0 2-1.7 3.7-3.7 3.7H4.4c-2 0-3.7-1.7-3.7-3.7V4.1C.7 2.1 2.4.4 4.4.4h6.1c2 0 3.7 1.7 3.7 3.7v18.8zM25.5.8h-.7c-1.8 0-3.3 1.5-3.3 3.3v18.8c0 1.8 1.5 3.3 3.3 3.3h.7c1.8 0 3.3-1.5 3.3-3.3V4.1C28.7 2.3 27.3.8 25.5.8zM39 .8h-.7C36.5.8 35 2.3 35 4.1v18.8c0 1.8 1.5 3.3 3.3 3.3h.7c1.8 0 3.3-1.5 3.3-3.3V4.1c0-1.8-1.4-3.3-3.3-3.3zm27.2 0h-.7c-1.8 0-3.3 1.5-3.3 3.3v6.4h-6.3V4.1c0-1.8-1.5-3.3-3.3-3.3H52c-1.8 0-3.3 1.5-3.3 3.3v18.8c0 1.8 1.5 3.3 3.3 3.3h.7c1.8 0 3.3-1.5 3.3-3.3v-6.4h6.3v6.4c0 1.8 1.5 3.3 3.3 3.3h.7c1.8 0 3.3-1.5 3.3-3.3V4.1C69.5 2.3 68.1.8 66.2.8zm24.5 5.9c1.6 0 3-1.3 3-3s-1.3-3-3-3H79.1c-1.8 0-3.3 1.5-3.3 3.3v18.8c0 1.8 1.5 3.3 3.3 3.3h.7c1.8 0 3.3-1.5 3.3-3.3v-6.4h7.6c1.6 0 3-1.3 3-3s-1.3-3-3-3h-7.6V6.7h7.6z"></path>
            </svg>
        </div>
        <div class="footer__icon">
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 70 27" width="67px">
                <path fill="#628EBA"
                      d="M9.1 25.6c0-.6.1-1.2.1-1.2s-.1-.3-.2-.5 0-.2 0-.3c0 0 0-.3-.1-.5-.2-.3-.6-1.1-.6-1.1l.1-.2-.3-.8s-2-1.5-2.8-2.2c-.8-.8-2.4-3.3-2.5-3.4-.1 0-.4.1-.4.1l-.2-.6c-.1-.2-.3-.8-.5-1.4-.2-.6-.4-1.1-.4-1.3 0-.3 0-.8.1-1.2.1-.3.6-.8.5-.8l-.1-.2s-.4.2-.8-.1c-.5-.4-.1-1.4.7-3.4.8-2 1.2-2.4 1.3-2.5.2-.1.3-.2.3-.2h.9l.1-.1h.8s.5 0 .3-1.3c0 0-.2-.4-.2-.5 0-.1.1-.2.1-.2.3-.3.3-.2.3-1L6 .4l.2-.4H2.4C1.5 0 .7.8.7 1.7v23.6c0 .9.8 1.7 1.7 1.7h7.1c-.1 0-.4-.5-.4-1.4z"></path>
                <path fill="#D7E9F9"
                      d="M3.9 25.5h-1l-.6-2.7v2.7h-.6v-3.4h1.1l.4 2.2v-2.2h.7zM6 23.1c0 .3-.1.6-.6.6.4 0 .6.2.6.7v.3c0 .6-.3.8-1 .8H4v-3.4h1c.5 0 1 .2 1 .7v.3zm1.4 2.4v-.9H7l-.2.9h-.7l.6-3.4h1.1l.5 3.4z"></path>
                <path fill="#628EBA"
                      d="M5 22.6h-.1v.9H5c.1 0 .2-.1.2-.2v-.5c0-.1 0-.2-.2-.2zM5 24h-.1v1H5c.1 0 .2 0 .2-.2V24H5zm2 .1h.3l-.1-1.4z"></path>
                <path fill="#D7E9F9"
                      d="M10 15.7c-1.1 0-2.1-.9-2.1-2.1 0-.9.6-1.6 1.4-1.9.1-.1.1-.2.1-.2s-.1-.3-.4-.7c-.3-.4-.6-1.4-.7-1.7-.1-.3-.3-1.8-.4-1.8-.1 0-.1 0-.3.1-.3.1-.5.6-.6.8-.1.2-.5 1.4-.6 1.4l.1.1s.3.2.4.3c.1.1.8 2.6.8 2.6l-.2.3s0 .2.1.6c.1.3.2.8.3 1.2l.5 2 .6 1.2c.3.6.6 2.8.6 2.8s.5.8.5 1.1c.1.3-.1 1-.1 1s0 .5.1.7c0 .1.1.3.1.4s.1.4.1.5c0 .1.5 1.6.5 1.7 0 .2-.3.7-.4.7l-.2.2c.9 0 1.7-.8 1.7-1.7V14.6c-.4.7-1.1 1.1-1.9 1.1zM10.1 0H7.5c.1 0 .6.4.7.5.1.1.1.3 0 .6l-.2.6v.2l.1.1s-.3.6-.4.6c0 0-.5.8-.6.9-.1.1-.1.3-.1.3.1.1.4.3.4.3h.2l.4.3s0 .1.2.3c.2.1.6.5.9.8.3.3.3 1.1.3 1.7 0 .6.3 1.9.3 2 .1.1.5 1.1.5 1.3.1.3.1.8.1.8l.4.5c.4.2.7.5.9.8v-11C11.8.8 11 0 10.1 0z"></path>
                <path fill="#628EBA"
                      d="M34.3 27h-7.7L22 5.8V27h-5V0h8.9l3.3 17.5.1-17.5h5zM51.5 7.5v-2c0-4.1-3.6-5.5-7.6-5.5h-7.6v27h7.6c5 0 7.6-1.4 7.6-6v-2.4c0-4.3-1.5-5.6-4.8-5.8v-.1c4-.7 4.8-2.6 4.8-5.2zM45 21.9c0 1.1-.5 1.3-1.5 1.3h-.8v-8.5h.8c1 0 1.5.2 1.5 1.3v5.9zm0-12.4c0 1.3-.5 1.7-1.5 1.7h-.8V3.9h.8c1 0 1.5.4 1.5 1.7v3.9zM65.5 0H57l-4.8 27h5.7l1-7.3H62l.7 7.3h6.7L65.5 0zm-6 15.8l1-11.1 1 11.1h-2z"></path>
            </svg>
        </div>
    </div>



</footer>
</div>
</main>

<?php wp_footer(); ?>

<?php
$code = carbon_get_theme_option('code');
if ($code) {
    echo $code;
}
?>


</body>
</html>
